/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EndSlimeEntity
extends SlimeEntity {
    private static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(EndSlimeEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    public EndSlimeEntity(EntityType<EndSlimeEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new EndSlimeMoveControl(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimmingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new FaceTowardTargetGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomLookGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, livingEntity -> Math.abs(livingEntity.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 1.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.15);
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, ILivingEntityData entityData, CompoundNBT entityTag) {
        ILivingEntityData data = super.func_213386_a(world, difficulty, spawnReason, entityData, entityTag);
        BetterEndBiome biome = ModBiomes.getFromBiome(world.func_226691_t_(this.func_233580_cy_()));
        if (biome == ModBiomes.FOGGY_MUSHROOMLAND) {
            this.setMossy();
        } else if (biome == ModBiomes.MEGALAKE || biome == ModBiomes.MEGALAKE_GROVE) {
            this.setLake();
        } else if (biome == ModBiomes.AMBER_LAND) {
            this.setAmber(true);
        }
        this.func_213323_x_();
        return data;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Variant", (byte)this.getSlimeType());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Variant")) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)compound.func_74771_c("Variant"));
        }
    }

    protected BasicParticleType getParticles() {
        return ParticleTypes.field_197599_J;
    }

    public void remove(boolean keepData) {
        int i = this.func_70809_q();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_233643_dh_()) {
            ITextComponent text = this.func_200201_e();
            boolean bl = this.func_175446_cd();
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.field_70146_Z.nextInt(3);
            int type = this.getSlimeType();
            for (int l = 0; l < k; ++l) {
                float g = ((float)(l % 2) - 0.5f) * f;
                float h = ((float)(l / 2) - 0.5f) * f;
                EndSlimeEntity slimeEntity = (EndSlimeEntity)this.func_200600_R().func_200721_a(this.field_70170_p);
                if (this.func_104002_bU()) {
                    slimeEntity.func_110163_bv();
                }
                slimeEntity.setSlimeType(type);
                slimeEntity.func_200203_b(text);
                slimeEntity.func_94061_f(bl);
                slimeEntity.func_184224_h(this.func_190530_aW());
                slimeEntity.func_70799_a(j, true);
                slimeEntity.func_213323_x_();
                slimeEntity.func_70012_b(this.func_226277_ct_() + (double)g, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + (double)h, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)slimeEntity);
            }
        }
        this.field_70128_L = true;
        super.remove(keepData);
    }

    public int getSlimeType() {
        return ((Byte)this.field_70180_af.func_187225_a(VARIANT)).intValue();
    }

    public void setSlimeType(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)((byte)value));
    }

    protected void setMossy() {
        this.setSlimeType(1);
    }

    public boolean isMossy() {
        return this.getSlimeType() == 1;
    }

    protected void setLake() {
        this.setSlimeType(2);
    }

    public boolean isLake() {
        return this.getSlimeType() == 2;
    }

    protected void setAmber(boolean mossy) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)3);
    }

    public boolean isAmber() {
        return (Byte)this.field_70180_af.func_187225_a(VARIANT) == 3;
    }

    public boolean isChorus() {
        return (Byte)this.field_70180_af.func_187225_a(VARIANT) == 0;
    }

    public static boolean canSpawn(EntityType<EndSlimeEntity> type, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return EndSlimeEntity.isPermanentBiome(world, pos) || EndSlimeEntity.notManyEntities(world, pos, 32, 3) && EndSlimeEntity.isWaterNear(world, pos, 32, 8);
    }

    private static boolean isPermanentBiome(IServerWorld world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        return ModBiomes.getFromBiome(biome) == ModBiomes.CHORUS_FOREST;
    }

    private static boolean notManyEntities(IServerWorld world, BlockPos pos, int radius, int maxCount) {
        AxisAlignedBB box = new AxisAlignedBB(pos).func_186662_g((double)radius);
        List list = world.func_175647_a(EndSlimeEntity.class, box, entity -> true);
        return list.size() <= maxCount;
    }

    private static boolean isWaterNear(IServerWorld world, BlockPos pos, int radius, int radius2) {
        for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
            POS.func_223471_o(x);
            for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                POS.func_223472_q(z);
                for (int y = pos.func_177956_o() - radius2; y <= pos.func_177956_o() + radius2; ++y) {
                    POS.func_185336_p(y);
                    if (world.func_180495_p((BlockPos)POS).func_177230_c() != Blocks.field_150355_j) continue;
                    return true;
                }
            }
        }
        return false;
    }

    class EndSlimeMoveControl
    extends MovementController {
        private float targetYaw;
        private int ticksUntilJump;
        private boolean jumpOften;

        public EndSlimeMoveControl(EndSlimeEntity slime) {
            super((MobEntity)slime);
            this.targetYaw = 180.0f * slime.field_70177_z / (float)Math.PI;
        }

        public void look(float targetYaw, boolean jumpOften) {
            this.targetYaw = targetYaw;
            this.jumpOften = jumpOften;
        }

        public void move(double speed) {
            this.field_75645_e = speed;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.targetYaw, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (this.ticksUntilJump-- <= 0) {
                        this.ticksUntilJump = EndSlimeEntity.this.func_70806_k();
                        if (this.jumpOften) {
                            this.ticksUntilJump /= 3;
                        }
                        EndSlimeEntity.this.func_70683_ar().func_75660_a();
                        if (EndSlimeEntity.this.func_70807_r()) {
                            EndSlimeEntity.this.func_184185_a(EndSlimeEntity.this.func_184710_cZ(), EndSlimeEntity.this.func_70599_aP(), this.getJumpSoundPitch());
                        }
                    } else {
                        EndSlimeEntity.this.field_70702_br = 0.0f;
                        EndSlimeEntity.this.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                }
            }
        }

        private float getJumpSoundPitch() {
            float f = EndSlimeEntity.this.func_189101_db() ? 1.4f : 0.8f;
            return ((EndSlimeEntity.this.field_70146_Z.nextFloat() - EndSlimeEntity.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * f;
        }
    }

    class FaceTowardTargetGoal
    extends Goal {
        private int ticksLeft;

        public FaceTowardTargetGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingEntity = EndSlimeEntity.this.func_70638_az();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.func_70089_S()) {
                return false;
            }
            return livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a ? false : EndSlimeEntity.this.func_70605_aq() instanceof EndSlimeMoveControl;
        }

        public void func_75249_e() {
            this.ticksLeft = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingEntity = EndSlimeEntity.this.func_70638_az();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.func_70089_S()) {
                return false;
            }
            if (livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.ticksLeft > 0;
        }

        public void func_75246_d() {
            EndSlimeEntity.this.func_70625_a((Entity)EndSlimeEntity.this.func_70638_az(), 10.0f, 10.0f);
            ((EndSlimeMoveControl)EndSlimeEntity.this.func_70605_aq()).look(EndSlimeEntity.this.field_70177_z, EndSlimeEntity.this.func_70800_m());
        }
    }

    class RandomLookGoal
    extends Goal {
        private float targetYaw;
        private int timer;

        public RandomLookGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return EndSlimeEntity.this.func_70638_az() == null && (EndSlimeEntity.this.field_70122_E || EndSlimeEntity.this.func_70090_H() || EndSlimeEntity.this.func_180799_ab() || EndSlimeEntity.this.func_70644_a(Effects.field_188424_y)) && EndSlimeEntity.this.func_70605_aq() instanceof EndSlimeMoveControl;
        }

        public void func_75246_d() {
            if (--this.timer <= 0) {
                this.timer = 40 + EndSlimeEntity.this.func_70681_au().nextInt(60);
                this.targetYaw = EndSlimeEntity.this.func_70681_au().nextInt(360);
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.func_70605_aq()).look(this.targetYaw, false);
        }
    }

    class SwimmingGoal
    extends Goal {
        public SwimmingGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            EndSlimeEntity.this.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (EndSlimeEntity.this.func_70090_H() || EndSlimeEntity.this.func_180799_ab()) && EndSlimeEntity.this.func_70605_aq() instanceof EndSlimeMoveControl;
        }

        public void func_75246_d() {
            if (EndSlimeEntity.this.func_70681_au().nextFloat() < 0.8f) {
                EndSlimeEntity.this.func_70683_ar().func_75660_a();
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.func_70605_aq()).move(1.2);
        }
    }

    class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (EndSlimeEntity.this.func_184218_aH()) {
                return false;
            }
            float yaw = EndSlimeEntity.this.func_70079_am();
            float speed = EndSlimeEntity.this.func_70689_ay();
            if ((double)speed > 0.1) {
                float dx = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float dz = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                BlockPos pos = EndSlimeEntity.this.func_233580_cy_().func_177963_a((double)(dx * speed * 4.0f), 0.0, (double)(dz * speed * 4.0f));
                int down = BlockHelper.downRay((IWorldReader)EndSlimeEntity.this.field_70170_p, pos, 16);
                return down < 5;
            }
            return true;
        }

        public void func_75246_d() {
            ((EndSlimeMoveControl)EndSlimeEntity.this.func_70605_aq()).move(1.0);
        }
    }
}

